!Object constantsFor: 'Geos Libraries'!

geosLIB15 'SYSTEM\connect'! !

!Object constantsFor: 'Geos vardata'!

tempConnectTempFilePath 8192!
tempConnectDestFilePath 8196!
tempConnectQuitVars 8200!
tempConnectIacpConnectionToken 8204!
attrConnectNoUserInteraction 8208!
tempConnectPccomNotifications 8212!
tempConnectAlternateOpenDialog 8216!
tempCmfConnectTransferFlags 8704!
tempCmfaDestFilePath 9216!
tempCmfaNewFileGeosFileName 9220!
tempCmfaPackageName 9224!
tempCmfaPackageFilename 9228!
tempCmfaRemotePackagePath 9232!
tempCmfaIacpConnectionToken 9236!
tempCmfaConnectTransferFlags 9240!
tempCmfaPackageDestination 9244!
attrConnectSettingsControlHelpFile 27648!
attrConnectSettingsControlHelpContext 27652!
attrConnectSettingsControlDefaultConnectionType 27656!
attrConnectSettingsControlDefaultDataGroup 27660!
attrConnectSettingsControlDefaultDrive 27664!
attrConnectSettingsControlDefaultDirectoryPath 27668!
attrConnectSettingsControlDefaultFilePath 27672!
attrConnectSettingsControlDefaultMemorycardDir 27676!
tempConnectSettingsControlDirArray 27680!
attrConnectSettingsControlDefaultDestinationType 27684!
hintConnectSettingsDisplayDontShowMemoryCardPath 27648!
tempConnectSubAppDetachData 27648!
!

!Object constantsFor: 'Geos messages'!

openConnection 8192!
closeConnection 8193!
sendFile 8194!
getFile 8195!
cancelTransfer 8196!
setTransferDriver 8197!
forceGeodeToQuit 8198!
contactServer 8199!
continueSendAfterTranslation 8200!
finishSendAfterTransfer 8201!
continueGetAfterTransfer 8202!
finishGetAfterTranslation 8203!
handleError 8204!
startTranslation 8205!
translationDone 8206!
pccomTransferStatus 8207!
transferDriverTransferStatus 8208!
allocateVardataPathBuffers 8209!
deleteVardataPathBuffers 8210!
continueForceLibraryToQuit 8211!
prepareForTransfer 8212!
resetAfterTransfer 8213!
mmcTransferStatus 8214!
setPccomNotifications 8215!
useOpenDialog 8216!
getFileArray 8704!
sendFileArray 8705!
sendNextFile 8706!
getNextFile 8707!
finishFileArray 8708!
setFileAction 9216!
getFileDetailsBlock 9217!
allocatePackageArray 9218!
listPackages 9219!
getPackage 9220!
getPackageGivenPackageFile 9221!
cancelGetPackage 9222!
finishListPackages 9223!
continueGetPackage 9224!
finishGetPackage 9225!
updatePackageDescriptorArray 9226!
fileActionForGetPackage 9227!
fileActionForGetPackageStage_2 9228!
continueGetNextFile 9229!
setPackageDestination 9230!
settingsControlInitiateDialog 27648!
settingsControlGetConnectionTypeSetting 27649!
settingsControlGetDataGroupSetting 27650!
settingsControlGetConnectionTypeText 27651!
settingsControlGetDataGroupText 27652!
settingsControlGetDriveText 27653!
settingsControlGetDirectoryPathText 27654!
settingsControlGetFilePathText 27655!
settingsControlCloseDialog 27656!
settingsControlWriteSettings 27657!
settingsControlReadSettings 27658!
settingsControlCheckLegalSettings 27659!
settingsControlSaveGigSettings 27660!
settingsControlGetDirectoryPathDisplayText 27661!
settingsControlNeedMoniker 27662!
settingsControlInitDynamicList 27663!
settingsControlSaveCtGigSettings 27664!
settingsControlGetMemorycardFolder 27665!
settingsControlAddFolder 27666!
settingsControlDoRenameFolderDialog 27667!
settingsControlRenameFolder 27668!
settingsControlDeleteFolder 27669!
settingsControlDirsSelected 27670!
settingsControlGetDestinationTypeSetting 27671!
settingsControlGetDestinationTypeText 27672!
settingsDisplayControlUpdateUi 27648!
getFlags 27648!
setFlags 27649!
continueDetach 27650!
progressDialogInitiateDialog 28160!
progressDialogDismissDialog 28161!
progressDialogDestroyDialog 28162!
progressDialogSetTransferSize 28163!
progressDialogReportProgress 28164!
progressDialogStartingNewFile 28165!
progressDialogCancel 28166!
progressDialogSetCancelAction 28167!
progressDialogGetFlags 28168!
progressDialogSuspendCancel 28169!
progressDialogResumeCancel 28170!
!

!Geos class methodsFor: 'library calls'!

ConnectCreateProgressDialog: cancellationOptr with: cancellationMsg
	"optr cdecl ConnectCreateProgressDialog(optr cancellationOptr, Message cancellationMsg) in connect.goh"
	^GEOS call: cancellationOptr with: cancellationMsg with: #[143 0 7 2 1 2]!

ConnectCreateProgressDialogFromTemplate: progressDialogTemplate with: cancellationOptr with: cancellationMsg
	"optr cdecl ConnectCreateProgressDialogFromTemplate(optr progressDialogTemplate, optr cancellationOptr, Message cancellationMsg) in connect.goh"
	^GEOS call: progressDialogTemplate with: cancellationOptr with: cancellationMsg with: #[143 0 8 2 2 1 2]!

ConnectDoStandardDialog: dialogType with: arg1 with: arg2
	"InteractionCommand cdecl ConnectDoStandardDialog( ConnectStandardDialogBoxType dialogType, TCHAR *arg1, TCHAR *arg2) in connect.goh"
	^GEOS call: dialogType with: arg1 with: arg2 with: #[143 0 9 1 3 3 1]!

ConnectMaybeDoStandardDialog: dialogType with: arg1 with: arg2 with: connectObj
	"InteractionCommand cdecl ConnectMaybeDoStandardDialog( ConnectStandardDialogBoxType dialogType, TCHAR *arg1, TCHAR *arg2, optr connectObj) in connect.goh"
	^GEOS call: dialogType with: arg1 with: arg2 with: connectObj with: #[143 0 35 1 3 3 2 1]!

ConnectSetServerPath: path
	"ConnectError cdecl ConnectSetServerPath(TCHAR *path) in connect.goh"
	^GEOS call: path with: #[143 0 10 3 1]!

ConnectGetServerPath: buffer
	"ConnectError cdecl ConnectGetServerPath(TCHAR *buffer) in connect.goh"
	^GEOS call: buffer with: #[143 0 11 3 1]!

ConnectDisplayServerPath
	"ConnectError cdecl ConnectDisplayServerPath(void) in connect.goh"
	^GEOS call: #[143 0 25 1]!

ConnectGetPackageDescriptorData: pkgDescArray with: n with: pddt with: retBuf with: bufLength
	"ConnectError cdecl ConnectGetPackageDescriptorData(optr pkgDescArray, word n, PackageDescriptorDataType pddt, TCHAR *retBuf, word bufLength ) in connect.goh"
	^GEOS call: pkgDescArray with: n with: pddt with: retBuf with: bufLength with: #[143 0 12 2 1 1 3 1 1]!

ConnectAbridgePath: thePath with: maxWidth with: includedInWidth with: fontID with: pointSize
	"void cdecl ConnectAbridgePath(char *thePath, word maxWidth, char *includedInWidth, FontID fontID, WWFixedAsDWord pointSize) in connect.goh"
	^GEOS call: thePath with: maxWidth with: includedInWidth with: fontID with: pointSize with: #[143 0 13 3 1 3 1 2 0]!

ConnectCheckLegalDosDriveName: driveName
	"ConnectCheckLegalError cdecl ConnectCheckLegalDosDriveName (const TCHAR *driveName) in connect.goh"
	^GEOS call: driveName with: #[143 0 14 3 1]!

ConnectCheckLegalDosDirPath: dirPath
	"ConnectCheckLegalError cdecl ConnectCheckLegalDosDirPath (const TCHAR *dirPath) in connect.goh"
	^GEOS call: dirPath with: #[143 0 15 3 1]!

ConnectCheckLegalDosFilePath: filePath
	"ConnectCheckLegalError cdecl ConnectCheckLegalDosFilePath (TCHAR *filePath) in connect.goh"
	^GEOS call: filePath with: #[143 0 16 3 1]!

ConnectCheckLegalDosFileName: fileName
	"ConnectCheckLegalError cdecl ConnectCheckLegalDosFileName (const TCHAR *fileName) in connect.goh"
	^GEOS call: fileName with: #[143 0 17 3 1]!

ConnectGeodeFindFromLongName: name with: attrMatch with: attrNoMatch with: geodeHan
	"ConnectError pascal ConnectGeodeFindFromLongName( const char *name, GeodeAttrs attrMatch, GeodeAttrs attrNoMatch, GeodeHandle *geodeHan) in connect.goh"
	^GEOS call: name with: attrMatch with: attrNoMatch with: geodeHan with: #[15 0 20 3 1 1 3 1]!

ConnectPlaySound: soundToPlay
	"void pascal ConnectPlaySound( ConnectSoundType soundToPlay ) in connect.goh"
	^GEOS call: soundToPlay with: #[15 0 24 1 0]!

ConnectMapPCCFRTToConnectError: defaultErr with: pccomErr
	"ConnectError cdecl ConnectMapPCCFRTToConnectError( ConnectError defaultErr, PCComFullReturnType pccomErr ) in connect.goh"
	^GEOS call: defaultErr with: pccomErr with: #[143 0 21 1 1 1]!

ConnectDoStandardDialogWithReason: error with: dbType with: arg
	"InteractionCommand cdecl ConnectDoStandardDialogWithReason( ConnectError error, ConnectStandardDialogBoxType dbType, TCHAR *arg ) in connect.goh"
	^GEOS call: error with: dbType with: arg with: #[143 0 22 1 1 3 1]!

ConnectDoStandardErrorDialog: error with: arg1 with: arg2
	"Boolean cdecl ConnectDoStandardErrorDialog( ConnectError error, TCHAR *arg1, TCHAR *arg2 ) in connect.goh"
	^GEOS call: error with: arg1 with: arg2 with: #[143 0 23 1 3 3 4]!

ConnectMaybeDoStandardErrorDialog: error with: arg1 with: arg2 with: connectObj
	"Boolean cdecl ConnectMaybeDoStandardErrorDialog( ConnectError error, TCHAR *arg1, TCHAR *arg2, optr connectObj) in connect.goh"
	^GEOS call: error with: arg1 with: arg2 with: connectObj with: #[143 0 34 1 3 3 2 4]!

ConnectDisableAppLaunchKeys: monitor
	"void pascal ConnectDisableAppLaunchKeys(ConnectDisableAppLaunchKeysMonitor *monitor) in connect.goh"
	^GEOS call: monitor with: #[15 0 26 3 0]!

ConnectEnableAppLaunchKeys: monitor
	"void pascal ConnectEnableAppLaunchKeys(ConnectDisableAppLaunchKeysMonitor *monitor) in connect.goh"
	^GEOS call: monitor with: #[15 0 27 3 0]!

ConnectCompressFile: srcFileHan with: destFileHan
	"word pascal ConnectCompressFile (FileHandle srcFileHan, FileHandle destFileHan) in connect.goh"
	^GEOS call: srcFileHan with: destFileHan with: #[15 0 28 1 1 1]!

ConnectDecompressFile: srcFileHan with: destFileHan
	"word pascal ConnectDecompressFile (FileHandle srcFileHan, FileHandle destFileHan) in connect.goh"
	^GEOS call: srcFileHan with: destFileHan with: #[15 0 29 1 1 1]!

ConnectGetFreeSpace: driveSpace with: driveLetter with: localSize
	"ConnectError cdecl ConnectGetFreeSpace (dword *driveSpace, word driveLetter, dword localSize) in connect.goh"
	^GEOS call: driveSpace with: driveLetter with: localSize with: #[143 0 30 3 1 2 1]!

ConnectFileEnum: params with: bufCreated with: numNoFit
	"word cdecl ConnectFileEnum (FileEnumParams *params, MemHandle *bufCreated, word *numNoFit) in connect.goh"
	^GEOS call: params with: bufCreated with: numNoFit with: #[143 0 31 3 3 3 1]!

ConnectGetFileSize: fileSize with: fileName
	"ConnectError cdecl ConnectGetFileSize (dword *fileSize, char *fileName) in connect.goh"
	^GEOS call: fileSize with: fileName with: #[143 0 32 3 3 1]!

ConnectRemark: error with: actionString
	"ConnectError cdecl ConnectRemark (ConnectError error, TCHAR *actionString) in connect.goh"
	^GEOS call: error with: actionString with: #[143 0 33 1 3 1]!

ConnectValidateIniPathSettings: fname
	"void cdecl ConnectValidateIniPathSettings(TCHAR *fname) in connect.goh"
	^GEOS call: fname with: #[143 0 38 3 0]!

!

Meta subclass: #Connect
	instanceVariableNames: ''
	classVariableNames: ''!

Connect subclass: #ConnectMultiFile
	instanceVariableNames: ''
	classVariableNames: ''!

ConnectMultiFile subclass: #ConnectMultiFileAction
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ConnectSettingsControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ConnectSettingsDisplayControl
	instanceVariableNames: ''
	classVariableNames: ''!

FoamSubApplication subclass: #ConnectSubApplication
	instanceVariableNames: ''
	classVariableNames: ''!

FoamProgressDialog subclass: #ConnectProgressDialog
	instanceVariableNames: ''
	classVariableNames: ''!

!Connect comment!
Library connect, file connect.goh! !

!Connect class methodsFor: 'library linkage'!

library
	^15!

entry
	^0000!
!

!Connect methodsFor: 'Geos instance variables'!

ciConnectGetSendStatus
	"@instance ConnectGetSendStatus CI_connectGetSendStatus"
	^self wordAt: 4!

ciConnectGetSendStatus: value
	"@instance ConnectGetSendStatus CI_connectGetSendStatus"
	^self wordAt: 4 put: value!

ciNotifyOnCompletionOptr
	"@instance optr CI_notifyOnCompletionOptr"
	^self dwordAt: 6!

ciNotifyOnCompletionOptr: value
	"@instance optr CI_notifyOnCompletionOptr"
	^self dwordAt: 6 put: value!

ciNotifyOnCompletionMsg
	"@instance Message CI_notifyOnCompletionMsg"
	^self wordAt: 10!

ciNotifyOnCompletionMsg: value
	"@instance Message CI_notifyOnCompletionMsg"
	^self wordAt: 10 put: value!

ciProgressDialogOptr
	"@instance optr CI_progressDialogOptr"
	^self dwordAt: 12!

ciProgressDialogOptr: value
	"@instance optr CI_progressDialogOptr"
	^self dwordAt: 12 put: value!

ciTempDiskHandle
	"@instance DiskHandle CI_tempDiskHandle"
	^self wordAt: 16!

ciTempDiskHandle: value
	"@instance DiskHandle CI_tempDiskHandle"
	^self wordAt: 16 put: value!

ciDestDiskHandle
	"@instance DiskHandle CI_destDiskHandle"
	^self wordAt: 18!

ciDestDiskHandle: value
	"@instance DiskHandle CI_destDiskHandle"
	^self wordAt: 18 put: value!

ciOriginalDestFile
	"@instance FileHandle CI_originalDestFile"
	^self wordAt: 20!

ciOriginalDestFile: value
	"@instance FileHandle CI_originalDestFile"
	^self wordAt: 20 put: value!

ciSourceFormat
	"@instance char[16] CI_sourceFormat"
	"#pointer [22, 16]"
	^self!

ciDestFormat
	"@instance char[16] CI_destFormat"
	"#pointer [38, 16]"
	^self!

ciGetSourceDataBlock
	"@instance MemHandle CI_getSourceDataBlock"
	^self wordAt: 54!

ciGetSourceDataBlock: value
	"@instance MemHandle CI_getSourceDataBlock"
	^self wordAt: 54 put: value!

ciXlateThread
	"@instance ThreadHandle CI_xlateThread"
	^self wordAt: 56!

ciXlateThread: value
	"@instance ThreadHandle CI_xlateThread"
	^self wordAt: 56 put: value!

ciXlateDrvHandle
	"@instance GeodeHandle CI_xlateDrvHandle"
	^self wordAt: 58!

ciXlateDrvHandle: value
	"@instance GeodeHandle CI_xlateDrvHandle"
	^self wordAt: 58 put: value!

ciXlateDrvStratRoutine
	"@instance void(*)() CI_xlateDrvStratRoutine"
	^self dwordAt: 60!

ciXlateDrvStratRoutine: value
	"@instance void(*)() CI_xlateDrvStratRoutine"
	^self dwordAt: 60 put: value!

ciOpenConnectionDialog
	"@instance optr CI_openConnectionDialog"
	^self dwordAt: 64!

ciOpenConnectionDialog: value
	"@instance optr CI_openConnectionDialog"
	^self dwordAt: 64 put: value!

ciOpenConnectionReturnObj
	"@instance optr CI_openConnectionReturnObj"
	^self dwordAt: 68!

ciOpenConnectionReturnObj: value
	"@instance optr CI_openConnectionReturnObj"
	^self dwordAt: 68 put: value!

ciOpenConnectionReturnMsg
	"@instance Message CI_openConnectionReturnMsg"
	^self wordAt: 72!

ciOpenConnectionReturnMsg: value
	"@instance Message CI_openConnectionReturnMsg"
	^self wordAt: 72 put: value!

ciOpenConnectionTimeOutTime
	"@instance dword CI_openConnectionTimeOutTime"
	^self dwordAt: 74!

ciOpenConnectionTimeOutTime: value
	"@instance dword CI_openConnectionTimeOutTime"
	^self dwordAt: 74 put: value!

ciOpenConnectionTimeOutFlags
	"@instance ConnectOpenConnectionTimeOutFlags CI_openConnectionTimeOutFlags"
	^self byteAt: 78!

ciOpenConnectionTimeOutFlags: value
	"@instance ConnectOpenConnectionTimeOutFlags CI_openConnectionTimeOutFlags"
	^self byteAt: 78 put: value!

ciXferDriverName
	"@instance FileLongName CI_xferDriverName"
	"#array #int8[36] [79, 36]"
	^self!

ciXferDrvHandle
	"@instance GeodeHandle CI_xferDrvHandle"
	^self wordAt: 115!

ciXferDrvHandle: value
	"@instance GeodeHandle CI_xferDrvHandle"
	^self wordAt: 115 put: value!

ciXferDrvStratRoutine
	"@instance void(*)() CI_xferDrvStratRoutine"
	^self dwordAt: 117!

ciXferDrvStratRoutine: value
	"@instance void(*)() CI_xferDrvStratRoutine"
	^self dwordAt: 117 put: value!

ciAvoidDetachCount
	"@instance word CI_avoidDetachCount"
	^self wordAt: 121!

ciAvoidDetachCount: value
	"@instance word CI_avoidDetachCount"
	^self wordAt: 121 put: value!

ciConnectionStatus
	"@instance ConnectConnectionStatus CI_connectionStatus"
	^self byteAt: 123!

ciConnectionStatus: value
	"@instance ConnectConnectionStatus CI_connectionStatus"
	^self byteAt: 123 put: value!

!

!Connect methodsFor: 'Geos vardata'!

tempConnectTempFilePath
	"@vardata PathAndFileName TEMP_CONNECT_TEMP_FILE_PATH"
	^self addVardata: ##tempConnectTempFilePath size: 234!

tempConnectDestFilePath
	"@vardata PathAndFileName TEMP_CONNECT_DEST_FILE_PATH"
	^self addVardata: ##tempConnectDestFilePath size: 234!

tempConnectQuitVars
	"@vardata ConnectQuitGeodeState TEMP_CONNECT_QUIT_VARS"
	^self addVardata: ##tempConnectQuitVars size: 39!

tempConnectQuitVars: aBlock
	"@vardata ConnectQuitGeodeState TEMP_CONNECT_QUIT_VARS"
	aBlock value: (GCSConnectQuitGeodeState forPointer: (self addVardata: ##tempConnectQuitVars size: 39)).!

tempConnectIacpConnectionToken: value
	"@vardata IACPConnection TEMP_CONNECT_IACP_CONNECTION_TOKEN"
	^self addVardata: ##tempConnectIacpConnectionToken word: value!

attrConnectNoUserInteraction
	"@vardata void ATTR_CONNECT_NO_USER_INTERACTION"
	^self addVardata: ##attrConnectNoUserInteraction!

tempConnectPccomNotifications
	"@vardata PCCNotifications TEMP_CONNECT_PCCOM_NOTIFICATIONS"
	^self addVardata: ##tempConnectPccomNotifications size: 6!

tempConnectPccomNotifications: aBlock
	"@vardata PCCNotifications TEMP_CONNECT_PCCOM_NOTIFICATIONS"
	aBlock value: (GCSPCCNotifications forPointer: (self addVardata: ##tempConnectPccomNotifications size: 6)).!

tempConnectAlternateOpenDialog: value
	"@vardata optr TEMP_CONNECT_ALTERNATE_OPEN_DIALOG"
	^self addVardata: ##tempConnectAlternateOpenDialog dword: value!

!

!Connect methodsFor: 'Geos messages'!

openConnection: cType with: timeOut with: completionOptr with: completionMsg
	"@message void MSG_CONNECT_OPEN_CONNECTION(ConnectionType cType, sword timeOut, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[32 0 1 0 1 4 2 1 0] with: cType with: timeOut with: completionOptr with: completionMsg!

closeConnection
	"@message ConnectError MSG_CONNECT_CLOSE_CONNECTION()"
	^self geosMessage: #[32 1 2 0 1]!

sendFile: localDiskHandle with: localFilePath with: remoteFilePath with: localFormat with: remoteFormat with: progressDialog with: flags with: completionOptr with: completionMsg
	"@message void MSG_CONNECT_SEND_FILE(DiskHandle localDiskHandle, TCHAR *localFilePath, TCHAR *remoteFilePath, char *localFormat, char *remoteFormat, optr progressDialog, ConnectTransferFlags flags, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[32 2 1 0 1 3 3 3 3 2 1 2 1 0] with: localDiskHandle with: localFilePath with: remoteFilePath with: localFormat with: remoteFormat with: progressDialog with: flags with: completionOptr with: completionMsg!

getFile: localDiskHandle with: localFilePath with: remoteFilePath with: localFormat with: remoteFormat with: progressDialog with: flags with: completionOptr with: completionMsg
	"@message void MSG_CONNECT_GET_FILE(DiskHandle localDiskHandle, TCHAR *localFilePath, TCHAR *remoteFilePath, char *localFormat, char *remoteFormat, optr progressDialog, ConnectTransferFlags flags, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[32 3 1 0 1 3 3 3 3 2 1 2 1 0] with: localDiskHandle with: localFilePath with: remoteFilePath with: localFormat with: remoteFormat with: progressDialog with: flags with: completionOptr with: completionMsg!

cancelTransfer
	"@message void MSG_CONNECT_CANCEL_TRANSFER()"
	^self geosMessage: #[32 4 2 0 0]!

setTransferDriver: driver
	"@message void MSG_CONNECT_SET_TRANSFER_DRIVER(char *driver)"
	^self geosMessage: #[32 5 1 0 3 0] with: driver!

forceGeodeToQuit: geode with: completionMsg with: completionOptr with: exceptThisApp
	"@message void MSG_CONNECT_FORCE_GEODE_TO_QUIT(GeodeHandle geode, word completionMsg, optr completionOptr, GeodeHandle exceptThisApp)"
	^self geosMessage: #[32 6 1 0 1 1 2 1 0] with: geode with: completionMsg with: completionOptr with: exceptThisApp!

contactServer
	"@message void MSG_CONNECT_CONTACT_SERVER()"
	^self geosMessage: #[32 7 2 0 0]!

continueSendAfterTranslation
	"@message void MSG_CONNECT_CONTINUE_SEND_AFTER_TRANSLATION()"
	^self geosMessage: #[32 8 2 0 0]!

finishSendAfterTransfer
	"@message void MSG_CONNECT_FINISH_SEND_AFTER_TRANSFER()"
	^self geosMessage: #[32 9 2 0 0]!

continueGetAfterTransfer
	"@message void MSG_CONNECT_CONTINUE_GET_AFTER_TRANSFER()"
	^self geosMessage: #[32 10 2 0 0]!

finishGetAfterTranslation
	"@message void MSG_CONNECT_FINISH_GET_AFTER_TRANSLATION()"
	^self geosMessage: #[32 11 2 0 0]!

handleError: error with: arg1 with: arg2
	"@message ConnectError MSG_CONNECT_HANDLE_ERROR(ConnectError error, TCHAR *arg1, TCHAR *arg2)"
	^self geosMessage: #[32 12 1 0 1 3 3 1] with: error with: arg1 with: arg2!

startTranslation: sourceDiskHandle with: sourceFilePath with: sourceFormat with: destDiskHandle with: destFilePath with: destFormat
	"@message ConnectError MSG_CONNECT_START_TRANSLATION(DiskHandle sourceDiskHandle, TCHAR *sourceFilePath, char *sourceFormat, DiskHandle destDiskHandle, TCHAR *destFilePath, char *destFormat)"
	^self geosMessage: #[32 13 1 0 1 3 3 1 3 3 1] with: sourceDiskHandle with: sourceFilePath with: sourceFormat with: destDiskHandle with: destFilePath with: destFormat!

translationDone: xlatError with: driverArgs
	"@message void MSG_CONNECT_TRANSLATION_DONE(ConnectTranslateDriverError xlatError, MemHandle driverArgs)"
	^self geosMessage: #[32 14 1 0 1 1 0] with: xlatError with: driverArgs!

pccomTransferStatus: fullReturnType with: bytesThisFile
	"@message void MSG_CONNECT_PCCOM_TRANSFER_STATUS(PCComFullReturnType fullReturnType = cx, dword bytesThisFile = dx:bp)"
	^self geosMessage: #[32 15 3 245 1 2 0] with: fullReturnType with: bytesThisFile!

transferDriverTransferStatus: params
	"@message void MSG_CONNECT_TRANSFER_DRIVER_TRANSFER_STATUS(ConnectTransferStatusParams *params = ss:bp)"
	^self geosMessage: #[32 16 0 128 3 0] with: params!

allocateVardataPathBuffers
	"@message void MSG_CONNECT_ALLOCATE_VARDATA_PATH_BUFFERS()"
	^self geosMessage: #[32 17 2 0 0]!

deleteVardataPathBuffers
	"@message void MSG_CONNECT_DELETE_VARDATA_PATH_BUFFERS()"
	^self geosMessage: #[32 18 2 0 0]!

continueForceLibraryToQuit: geode with: status
	"@message void MSG_CONNECT_CONTINUE_FORCE_LIBRARY_TO_QUIT(GeodeHandle geode, ConnectQuitGeodeStatus status)"
	^self geosMessage: #[32 19 1 0 1 1 0] with: geode with: status!

prepareForTransfer: flags
	"@message ConnectError MSG_CONNECT_PREPARE_FOR_TRANSFER(ConnectTransferFlags flags)"
	^self geosMessage: #[32 20 1 0 1 1] with: flags!

resetAfterTransfer
	"@message void MSG_CONNECT_RESET_AFTER_TRANSFER()"
	^self geosMessage: #[32 21 2 0 0]!

mmcTransferStatus: returnType with: bytesThisFile
	"@message void MSG_CONNECT_MMC_TRANSFER_STATUS(MMCReturnType returnType, dword bytesThisFile)"
	^self geosMessage: #[32 22 1 0 1 2 0] with: returnType with: bytesThisFile!

setPccomNotifications: flags with: output
	"@message void MSG_CONNECT_SET_PCCOM_NOTIFICATIONS(PCComInitFlags flags, optr output)"
	^self geosMessage: #[32 23 1 0 1 2 0] with: flags with: output!

useOpenDialog: progressDialog
	"@message void MSG_CONNECT_USE_OPEN_DIALOG(optr progressDialog)"
	^self geosMessage: #[32 24 1 0 2 0] with: progressDialog!

!

!ConnectMultiFile comment!
Library connect, file connect.goh! !

!ConnectMultiFile class methodsFor: 'library linkage'!

library
	^15!

entry
	^0004!
!

!ConnectMultiFile methodsFor: 'Geos instance variables'!

cmfiFileArray
	"@instance optr CMFI_fileArray"
	^self dwordAt: 124!

cmfiFileArray: value
	"@instance optr CMFI_fileArray"
	^self dwordAt: 124 put: value!

cmfiNextFile
	"@instance word CMFI_nextFile"
	^self wordAt: 128!

cmfiNextFile: value
	"@instance word CMFI_nextFile"
	^self wordAt: 128 put: value!

cmfiProgressDialog
	"@instance optr CMFI_progressDialog"
	^self dwordAt: 130!

cmfiProgressDialog: value
	"@instance optr CMFI_progressDialog"
	^self dwordAt: 130 put: value!

cmfiCompletionOptr
	"@instance optr CMFI_completionOptr"
	^self dwordAt: 134!

cmfiCompletionOptr: value
	"@instance optr CMFI_completionOptr"
	^self dwordAt: 134 put: value!

cmfiCompletionMsg
	"@instance Message CMFI_completionMsg"
	^self wordAt: 138!

cmfiCompletionMsg: value
	"@instance Message CMFI_completionMsg"
	^self wordAt: 138 put: value!

cmfiConnectmfGetSendStatus
	"@instance ConnectMFGetSendStatus CMFI_connectmfGetSendStatus"
	^self wordAt: 140!

cmfiConnectmfGetSendStatus: value
	"@instance ConnectMFGetSendStatus CMFI_connectmfGetSendStatus"
	^self wordAt: 140 put: value!

!

!ConnectMultiFile methodsFor: 'Geos vardata'!

tempCmfConnectTransferFlags: value
	"@vardata ConnectTransferFlags TEMP_CMF_CONNECT_TRANSFER_FLAGS"
	^self addVardata: ##tempCmfConnectTransferFlags byte: value!

!

!ConnectMultiFile methodsFor: 'Geos messages'!

getFileArray: array with: flags with: progressDialog with: completionOptr with: completionMsg
	"@message void MSG_CMF_GET_FILE_ARRAY( optr array, ConnectTransferFlags flags, optr progressDialog, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[34 0 1 0 2 1 2 2 1 0] with: array with: flags with: progressDialog with: completionOptr with: completionMsg!

sendFileArray: array with: flags with: progressDialog with: completionOptr with: completionMsg
	"@message void MSG_CMF_SEND_FILE_ARRAY( optr array, ConnectTransferFlags flags, optr progressDialog, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[34 1 1 0 2 1 2 2 1 0] with: array with: flags with: progressDialog with: completionOptr with: completionMsg!

sendNextFile: error
	"@message void MSG_CMF_SEND_NEXT_FILE(ConnectError error)"
	^self geosMessage: #[34 2 1 0 1 0] with: error!

getNextFile: error
	"@message void MSG_CMF_GET_NEXT_FILE(ConnectError error)"
	^self geosMessage: #[34 3 1 0 1 0] with: error!

finishFileArray: error
	"@message void MSG_CMF_FINISH_FILE_ARRAY(ConnectError error)"
	^self geosMessage: #[34 4 1 0 1 0] with: error!

!

!ConnectMultiFileAction comment!
Library connect, file connect.goh! !

!ConnectMultiFileAction class methodsFor: 'library linkage'!

library
	^15!

entry
	^0005!
!

!ConnectMultiFileAction methodsFor: 'Geos instance variables'!

cmfaiPackageArray
	"@instance optr CMFAI_packageArray"
	^self dwordAt: 142!

cmfaiPackageArray: value
	"@instance optr CMFAI_packageArray"
	^self dwordAt: 142 put: value!

cmfaiFileDetailsBlock
	"@instance MemHandle CMFAI_fileDetailsBlock"
	^self wordAt: 146!

cmfaiFileDetailsBlock: value
	"@instance MemHandle CMFAI_fileDetailsBlock"
	^self wordAt: 146 put: value!

cmfaiFileActionOptr
	"@instance optr CMFAI_fileActionOptr"
	^self dwordAt: 148!

cmfaiFileActionOptr: value
	"@instance optr CMFAI_fileActionOptr"
	^self dwordAt: 148 put: value!

cmfaiFileActionMsg
	"@instance Message CMFAI_fileActionMsg"
	^self wordAt: 152!

cmfaiFileActionMsg: value
	"@instance Message CMFAI_fileActionMsg"
	^self wordAt: 152 put: value!

cmfaiCompletionOptr
	"@instance optr CMFAI_completionOptr"
	^self dwordAt: 154!

cmfaiCompletionOptr: value
	"@instance optr CMFAI_completionOptr"
	^self dwordAt: 154 put: value!

cmfaiCompletionMsg
	"@instance Message CMFAI_completionMsg"
	^self wordAt: 158!

cmfaiCompletionMsg: value
	"@instance Message CMFAI_completionMsg"
	^self wordAt: 158 put: value!

cmfaiGetPackageStatus
	"@instance ConnectMFAGetPackageStatus CMFAI_getPackageStatus"
	^self wordAt: 160!

cmfaiGetPackageStatus: value
	"@instance ConnectMFAGetPackageStatus CMFAI_getPackageStatus"
	^self wordAt: 160 put: value!

mfaiGetPackageFileActionCompletionOptr
	"@instance optr MFAI_getPackageFileActionCompletionOptr"
	^self dwordAt: 162!

mfaiGetPackageFileActionCompletionOptr: value
	"@instance optr MFAI_getPackageFileActionCompletionOptr"
	^self dwordAt: 162 put: value!

mfaiGetPackageFileActionCompletionMsg
	"@instance Message MFAI_getPackageFileActionCompletionMsg"
	^self wordAt: 166!

mfaiGetPackageFileActionCompletionMsg: value
	"@instance Message MFAI_getPackageFileActionCompletionMsg"
	^self wordAt: 166 put: value!

!

!ConnectMultiFileAction methodsFor: 'Geos vardata'!

tempCmfaDestFilePath
	"@vardata PathAndFileName TEMP_CMFA_DEST_FILE_PATH"
	^self addVardata: ##tempCmfaDestFilePath size: 234!

tempCmfaNewFileGeosFileName
	"@vardata FileLongName TEMP_CMFA_NEW_FILE_GEOS_FILE_NAME"
	^self addVardata: ##tempCmfaNewFileGeosFileName size: 36!

tempCmfaPackageName
	"@vardata char[] TEMP_CMFA_PACKAGE_NAME"
	^self addVardata: ##tempCmfaPackageName size: 0!

tempCmfaPackageFilename
	"@vardata TCHAR[] TEMP_CMFA_PACKAGE_FILENAME"
	^self addVardata: ##tempCmfaPackageFilename size: 0!

tempCmfaRemotePackagePath
	"@vardata TCHAR[] TEMP_CMFA_REMOTE_PACKAGE_PATH"
	^self addVardata: ##tempCmfaRemotePackagePath size: 0!

tempCmfaIacpConnectionToken: value
	"@vardata IACPConnection TEMP_CMFA_IACP_CONNECTION_TOKEN"
	^self addVardata: ##tempCmfaIacpConnectionToken word: value!

tempCmfaConnectTransferFlags: value
	"@vardata ConnectTransferFlags TEMP_CMFA_CONNECT_TRANSFER_FLAGS"
	^self addVardata: ##tempCmfaConnectTransferFlags byte: value!

tempCmfaPackageDestination
	"@vardata PackageRoot TEMP_CMFA_PACKAGE_DESTINATION"
	^self addVardata: ##tempCmfaPackageDestination size: 2!

tempCmfaPackageDestination: aBlock
	"@vardata PackageRoot TEMP_CMFA_PACKAGE_DESTINATION"
	aBlock value: (GCSPackageRoot forPointer: (self addVardata: ##tempCmfaPackageDestination size: 2)).!

!

!ConnectMultiFileAction methodsFor: 'Geos messages'!

setFileAction: fileActionOptr with: fileActionMsg
	"@message void MSG_CMFA_SET_FILE_ACTION(optr fileActionOptr, Message fileActionMsg)"
	^self geosMessage: #[36 0 1 0 2 1 0] with: fileActionOptr with: fileActionMsg!

getFileDetailsBlock
	"@message MemHandle MSG_CMFA_GET_FILE_DETAILS_BLOCK()"
	^self geosMessage: #[36 1 2 0 1]!

allocatePackageArray: headerSize
	"@message void MSG_CMFA_ALLOCATE_PACKAGE_ARRAY( word headerSize)"
	^self geosMessage: #[36 2 1 0 1 0] with: headerSize!

listPackages: remotePath with: flags with: progressDialog with: completionOptr with: completionMsg
	"@message void MSG_CMFA_LIST_PACKAGES( TCHAR *remotePath, ConnectTransferFlags flags, optr progressDialog, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[36 3 1 0 3 1 2 2 1 0] with: remotePath with: flags with: progressDialog with: completionOptr with: completionMsg!

getPackage: packageArray with: n with: flags with: progressDialog with: completionOptr with: completionMsg
	"@message void MSG_CMFA_GET_PACKAGE( optr packageArray, word n, ConnectTransferFlags flags, optr progressDialog, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[36 4 1 0 2 1 1 2 2 1 0] with: packageArray with: n with: flags with: progressDialog with: completionOptr with: completionMsg!

getPackageGivenPackageFile: localDiskHandle with: localPackageFilePath with: remotePackagePath with: flags with: progressDialog with: completionOptr with: completionMsg
	"@message void MSG_CMFA_GET_PACKAGE_GIVEN_PACKAGE_FILE( DiskHandle localDiskHandle, TCHAR *localPackageFilePath, TCHAR *remotePackagePath, ConnectTransferFlags flags, optr progressDialog, optr completionOptr, Message completionMsg)"
	^self geosMessage: #[36 5 1 0 1 3 3 1 2 2 1 0] with: localDiskHandle with: localPackageFilePath with: remotePackagePath with: flags with: progressDialog with: completionOptr with: completionMsg!

cancelGetPackage
	"@message void MSG_CMFA_CANCEL_GET_PACKAGE()"
	^self geosMessage: #[36 6 2 0 0]!

finishListPackages: error
	"@message void MSG_CMFA_FINISH_LIST_PACKAGES(ConnectError error)"
	^self geosMessage: #[36 7 1 0 1 0] with: error!

continueGetPackage: error
	"@message void MSG_CMFA_CONTINUE_GET_PACKAGE(ConnectError error)"
	^self geosMessage: #[36 8 1 0 1 0] with: error!

finishGetPackage: error
	"@message void MSG_CMFA_FINISH_GET_PACKAGE(ConnectError error)"
	^self geosMessage: #[36 9 1 0 1 0] with: error!

updatePackageDescriptorArray: completionOptr with: completionMsg
	"@message void MSG_CMFA_UPDATE_PACKAGE_DESCRIPTOR_ARRAY(optr completionOptr, Message completionMsg)"
	^self geosMessage: #[36 10 1 0 2 1 0] with: completionOptr with: completionMsg!

fileActionForGetPackage: completionOptr with: completionMsg
	"@message void MSG_CMFA_FILE_ACTION_FOR_GET_PACKAGE(optr completionOptr, Message completionMsg)"
	^self geosMessage: #[36 11 1 0 2 1 0] with: completionOptr with: completionMsg!

fileActionForGetPackageStage_2: geode with: status
	"@message void MSG_CMFA_FILE_ACTION_FOR_GET_PACKAGE_STAGE_2(GeodeHandle geode, ConnectQuitGeodeStatus status)"
	^self geosMessage: #[36 12 1 0 1 1 0] with: geode with: status!

continueGetNextFile: error
	"@message void MSG_CMFA_CONTINUE_GET_NEXT_FILE(ConnectError error)"
	^self geosMessage: #[36 13 1 0 1 0] with: error!

setPackageDestination: rootDrive with: rootPath
	"@message void MSG_CMFA_SET_PACKAGE_DESTINATION( DiskHandle rootDrive, TCHAR *rootPath)"
	^self geosMessage: #[36 14 1 0 1 3 0] with: rootDrive with: rootPath!

!

!ConnectSettingsControl comment!
Library connect, file connect.goh! !

!ConnectSettingsControl class methodsFor: 'library linkage'!

library
	^15!

entry
	^0001!
!

!ConnectSettingsControl methodsFor: 'Geos instance variables'!

csciMiscFlags
	"@instance ConnectSettingsControllerMiscFlags CSCI_miscFlags"
	^self byteAt: 25!

csciMiscFlags: value
	"@instance ConnectSettingsControllerMiscFlags CSCI_miscFlags"
	^self byteAt: 25 put: value!

csciDialogTitle
	"@instance ChunkHandle CSCI_dialogTitle"
	^self wordAt: 26!

csciDialogTitle: value
	"@instance ChunkHandle CSCI_dialogTitle"
	^self wordAt: 26 put: value!

csciSettingsDisplayController
	"@instance optr CSCI_settingsDisplayController"
	^self dwordAt: 28!

csciSettingsDisplayController: value
	"@instance optr CSCI_settingsDisplayController"
	^self dwordAt: 28 put: value!

!

!ConnectSettingsControl methodsFor: 'Geos vardata'!

attrConnectSettingsControlHelpFile
	"@vardata char[] ATTR_CONNECT_SETTINGS_CONTROL_HELP_FILE"
	^self addVardata: ##attrConnectSettingsControlHelpFile size: 0!

attrConnectSettingsControlHelpContext
	"@vardata char[] ATTR_CONNECT_SETTINGS_CONTROL_HELP_CONTEXT"
	^self addVardata: ##attrConnectSettingsControlHelpContext size: 0!

attrConnectSettingsControlDefaultConnectionType: value
	"@vardata ConnectionType ATTR_CONNECT_SETTINGS_CONTROL_DEFAULT_CONNECTION_TYPE"
	^self addVardata: ##attrConnectSettingsControlDefaultConnectionType word: value!

attrConnectSettingsControlDefaultDataGroup: value
	"@vardata DataGroup ATTR_CONNECT_SETTINGS_CONTROL_DEFAULT_DATA_GROUP"
	^self addVardata: ##attrConnectSettingsControlDefaultDataGroup word: value!

attrConnectSettingsControlDefaultDrive
	"@vardata char[] ATTR_CONNECT_SETTINGS_CONTROL_DEFAULT_DRIVE"
	^self addVardata: ##attrConnectSettingsControlDefaultDrive size: 0!

attrConnectSettingsControlDefaultDirectoryPath
	"@vardata char[] ATTR_CONNECT_SETTINGS_CONTROL_DEFAULT_DIRECTORY_PATH"
	^self addVardata: ##attrConnectSettingsControlDefaultDirectoryPath size: 0!

attrConnectSettingsControlDefaultFilePath
	"@vardata char[] ATTR_CONNECT_SETTINGS_CONTROL_DEFAULT_FILE_PATH"
	^self addVardata: ##attrConnectSettingsControlDefaultFilePath size: 0!

attrConnectSettingsControlDefaultMemorycardDir
	"@vardata char[] ATTR_CONNECT_SETTINGS_CONTROL_DEFAULT_MEMORYCARD_DIR"
	^self addVardata: ##attrConnectSettingsControlDefaultMemorycardDir size: 0!

tempConnectSettingsControlDirArray: value
	"@vardata optr TEMP_CONNECT_SETTINGS_CONTROL_DIR_ARRAY"
	^self addVardata: ##tempConnectSettingsControlDirArray dword: value!

attrConnectSettingsControlDefaultDestinationType: value
	"@vardata DestinationType ATTR_CONNECT_SETTINGS_CONTROL_DEFAULT_DESTINATION_TYPE"
	^self addVardata: ##attrConnectSettingsControlDefaultDestinationType word: value!

!

!ConnectSettingsControl methodsFor: 'Geos messages'!

settingsControlInitiateDialog
	"@message void MSG_CONNECT_SETTINGS_CONTROL_INITIATE_DIALOG()"
	^self geosMessage: #[108 0 2 0 0]!

settingsControlGetConnectionTypeSetting
	"@message ConnectionType MSG_CONNECT_SETTINGS_CONTROL_GET_CONNECTION_TYPE_SETTING()"
	^self geosMessage: #[108 1 2 0 1]!

settingsControlGetDataGroupSetting
	"@message DataGroup MSG_CONNECT_SETTINGS_CONTROL_GET_DATA_GROUP_SETTING()"
	^self geosMessage: #[108 2 2 0 1]!

settingsControlGetConnectionTypeText: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_CONNECTION_TYPE_TEXT(TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 3 1 0 3 1 0] with: buffer with: bufferLength!

settingsControlGetDataGroupText: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_DATA_GROUP_TEXT(TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 4 1 0 3 1 0] with: buffer with: bufferLength!

settingsControlGetDriveText: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_DRIVE_TEXT(TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 5 1 0 3 1 0] with: buffer with: bufferLength!

settingsControlGetDirectoryPathText: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_DIRECTORY_PATH_TEXT(TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 6 1 0 3 1 0] with: buffer with: bufferLength!

settingsControlGetFilePathText: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_FILE_PATH_TEXT(TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 7 1 0 3 1 0] with: buffer with: bufferLength!

settingsControlCloseDialog
	"@message void MSG_CONNECT_SETTINGS_CONTROL_CLOSE_DIALOG()"
	^self geosMessage: #[108 8 2 0 0]!

settingsControlWriteSettings
	"@message void MSG_CONNECT_SETTINGS_CONTROL_WRITE_SETTINGS()"
	^self geosMessage: #[108 9 2 0 0]!

settingsControlReadSettings
	"@message void MSG_CONNECT_SETTINGS_CONTROL_READ_SETTINGS()"
	^self geosMessage: #[108 10 2 0 0]!

settingsControlCheckLegalSettings: flags
	"@message ConnectSettingsControlFeatures MSG_CONNECT_SETTINGS_CONTROL_CHECK_LEGAL_SETTINGS(CheckLegalSettingsFlags flags)"
	^self geosMessage: #[108 11 1 0 1 1] with: flags!

settingsControlSaveGigSettings
	"@message void MSG_CONNECT_SETTINGS_CONTROL_SAVE_GIG_SETTINGS()"
	^self geosMessage: #[108 12 2 0 0]!

settingsControlGetDirectoryPathDisplayText: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_DIRECTORY_PATH_DISPLAY_TEXT( TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 13 1 0 3 1 0] with: buffer with: bufferLength!

settingsControlNeedMoniker: theList with: index
	"@message void MSG_CONNECT_SETTINGS_CONTROL_NEED_MONIKER(optr theList = cx:dx, word index = bp)"
	^self geosMessage: #[108 14 3 245 2 1 0] with: theList with: index!

settingsControlInitDynamicList
	"@message void MSG_CONNECT_SETTINGS_CONTROL_INIT_DYNAMIC_LIST()"
	^self geosMessage: #[108 15 2 0 0]!

settingsControlSaveCtGigSettings
	"@message void MSG_CONNECT_SETTINGS_CONTROL_SAVE_CT_GIG_SETTINGS()"
	^self geosMessage: #[108 16 2 0 0]!

settingsControlGetMemorycardFolder: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_MEMORYCARD_FOLDER(TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 17 1 0 3 1 0] with: buffer with: bufferLength!

settingsControlAddFolder
	"@message void MSG_CONNECT_SETTINGS_CONTROL_ADD_FOLDER()"
	^self geosMessage: #[108 18 2 0 0]!

settingsControlDoRenameFolderDialog
	"@message void MSG_CONNECT_SETTINGS_CONTROL_DO_RENAME_FOLDER_DIALOG()"
	^self geosMessage: #[108 19 2 0 0]!

settingsControlRenameFolder
	"@message void MSG_CONNECT_SETTINGS_CONTROL_RENAME_FOLDER()"
	^self geosMessage: #[108 20 2 0 0]!

settingsControlDeleteFolder
	"@message void MSG_CONNECT_SETTINGS_CONTROL_DELETE_FOLDER()"
	^self geosMessage: #[108 21 2 0 0]!

settingsControlDirsSelected: selection with: numSelections with: stateFlags
	"@message void MSG_CONNECT_SETTINGS_CONTROL_DIRS_SELECTED( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 22 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

settingsControlGetDestinationTypeSetting
	"@message DestinationType MSG_CONNECT_SETTINGS_CONTROL_GET_DESTINATION_TYPE_SETTING()"
	^self geosMessage: #[108 23 2 0 1]!

settingsControlGetDestinationTypeText: buffer with: bufferLength
	"@message void MSG_CONNECT_SETTINGS_CONTROL_GET_DESTINATION_TYPE_TEXT(TCHAR *buffer, word bufferLength)"
	^self geosMessage: #[108 24 1 0 3 1 0] with: buffer with: bufferLength!

!

!ConnectSettingsDisplayControl comment!
Library connect, file connect.goh! !

!ConnectSettingsDisplayControl class methodsFor: 'library linkage'!

library
	^15!

entry
	^0002!
!

!ConnectSettingsDisplayControl methodsFor: 'Geos instance variables'!

csdciSettingsController
	"@instance optr CSDCI_settingsController"
	^self dwordAt: 25!

csdciSettingsController: value
	"@instance optr CSDCI_settingsController"
	^self dwordAt: 25 put: value!

!

!ConnectSettingsDisplayControl methodsFor: 'Geos vardata'!

hintConnectSettingsDisplayDontShowMemoryCardPath
	"@vardata void HINT_CONNECT_SETTINGS_DISPLAY_DONT_SHOW_MEMORY_CARD_PATH"
	^self addVardata: ##hintConnectSettingsDisplayDontShowMemoryCardPath!

!

!ConnectSettingsDisplayControl methodsFor: 'Geos messages'!

settingsDisplayControlUpdateUi
	"@message void MSG_CONNECT_SETTINGS_DISPLAY_CONTROL_UPDATE_UI()"
	^self geosMessage: #[108 0 2 0 0]!

!

!ConnectSubApplication comment!
Library connect, file connect.goh! !

!ConnectSubApplication class methodsFor: 'library linkage'!

library
	^15!

entry
	^0006!
!

!ConnectSubApplication methodsFor: 'Geos instance variables'!

csaiFlags
	"@instance ConnectSubApplicationFlags CSAI_flags"
	^self byteAt: 273!

csaiFlags: value
	"@instance ConnectSubApplicationFlags CSAI_flags"
	^self byteAt: 273 put: value!

csaiConnectObj
	"@instance optr CSAI_connectObj"
	^self dwordAt: 274!

csaiConnectObj: value
	"@instance optr CSAI_connectObj"
	^self dwordAt: 274 put: value!

!

!ConnectSubApplication methodsFor: 'Geos vardata'!

tempConnectSubAppDetachData
	"@vardata ConnectSubAppDetachData TEMP_CONNECT_SUB_APP_DETACH_DATA"
	^self addVardata: ##tempConnectSubAppDetachData size: 6!

tempConnectSubAppDetachData: aBlock
	"@vardata ConnectSubAppDetachData TEMP_CONNECT_SUB_APP_DETACH_DATA"
	aBlock value: (GCSConnectSubAppDetachData forPointer: (self addVardata: ##tempConnectSubAppDetachData size: 6)).!

!

!ConnectSubApplication methodsFor: 'Geos messages'!

getFlags
	"@message ConnectSubApplicationFlags MSG_CSA_GET_FLAGS()"
	^self geosMessage: #[108 0 2 0 1]!

setFlags: flagsToSet with: flagsToClear
	"@message ConnectSubApplicationFlags MSG_CSA_SET_FLAGS(ConnectSubApplicationFlags flagsToSet, ConnectSubApplicationFlags flagsToClear)"
	^self geosMessage: #[108 1 1 0 1 1 1] with: flagsToSet with: flagsToClear!

continueDetach
	"@message void MSG_CSA_CONTINUE_DETACH()"
	^self geosMessage: #[108 2 2 0 0]!

!

!ConnectProgressDialog comment!
Library connect, file connect.goh! !

!ConnectProgressDialog class methodsFor: 'library linkage'!

library
	^15!

entry
	^0003!
!

!ConnectProgressDialog methodsFor: 'Geos instance variables'!

cpdiFlags
	"@instance ConnectProgressDialogFlags CPDI_flags"
	^self byteAt: 35!

cpdiFlags: value
	"@instance ConnectProgressDialogFlags CPDI_flags"
	^self byteAt: 35 put: value!

cpdiCumulativeTally
	"@instance dword CPDI_cumulativeTally"
	^self dwordAt: 36!

cpdiCumulativeTally: value
	"@instance dword CPDI_cumulativeTally"
	^self dwordAt: 36 put: value!

cpdiBytesCurrentFile
	"@instance dword CPDI_bytesCurrentFile"
	^self dwordAt: 40!

cpdiBytesCurrentFile: value
	"@instance dword CPDI_bytesCurrentFile"
	^self dwordAt: 40 put: value!

cpdiTransferSize
	"@instance dword CPDI_transferSize"
	^self dwordAt: 44!

cpdiTransferSize: value
	"@instance dword CPDI_transferSize"
	^self dwordAt: 44 put: value!

cpdiCancellationOptr
	"@instance optr CPDI_cancellationOptr"
	^self dwordAt: 48!

cpdiCancellationOptr: value
	"@instance optr CPDI_cancellationOptr"
	^self dwordAt: 48 put: value!

cpdiCancellationMsg
	"@instance Message CPDI_cancellationMsg"
	^self wordAt: 52!

cpdiCancellationMsg: value
	"@instance Message CPDI_cancellationMsg"
	^self wordAt: 52 put: value!

cpdiCancelDialog
	"@instance optr CPDI_cancelDialog"
	^self dwordAt: 54!

cpdiCancelDialog: value
	"@instance optr CPDI_cancelDialog"
	^self dwordAt: 54 put: value!

!

!ConnectProgressDialog methodsFor: 'Geos vardata'!

!

!ConnectProgressDialog methodsFor: 'Geos messages'!

progressDialogInitiateDialog: flags
	"@message void MSG_CONNECT_PROGRESS_DIALOG_INITIATE_DIALOG(ConnectProgressDialogFlags flags)"
	^self geosMessage: #[110 0 1 0 1 0] with: flags!

progressDialogDismissDialog
	"@message void MSG_CONNECT_PROGRESS_DIALOG_DISMISS_DIALOG()"
	^self geosMessage: #[110 1 2 0 0]!

progressDialogDestroyDialog
	"@message void MSG_CONNECT_PROGRESS_DIALOG_DESTROY_DIALOG()"
	^self geosMessage: #[110 2 2 0 0]!

progressDialogSetTransferSize: size
	"@message void MSG_CONNECT_PROGRESS_DIALOG_SET_TRANSFER_SIZE(dword size)"
	^self geosMessage: #[110 3 1 0 2 0] with: size!

progressDialogReportProgress: type with: data
	"@message void MSG_CONNECT_PROGRESS_DIALOG_REPORT_PROGRESS(ConnectProgressType type, dword data)"
	^self geosMessage: #[110 4 1 0 1 2 0] with: type with: data!

progressDialogStartingNewFile: dataBlock
	"@message void MSG_CONNECT_PROGRESS_DIALOG_STARTING_NEW_FILE(MemHandle dataBlock)"
	^self geosMessage: #[110 5 1 0 1 0] with: dataBlock!

progressDialogCancel
	"@message void MSG_CONNECT_PROGRESS_DIALOG_CANCEL()"
	^self geosMessage: #[110 6 2 0 0]!

progressDialogSetCancelAction: cancellationOptr with: cancellationMsg
	"@message void MSG_CONNECT_PROGRESS_DIALOG_SET_CANCEL_ACTION(optr cancellationOptr, Message cancellationMsg)"
	^self geosMessage: #[110 7 1 0 2 1 0] with: cancellationOptr with: cancellationMsg!

progressDialogGetFlags
	"@message ConnectProgressDialogFlags MSG_CONNECT_PROGRESS_DIALOG_GET_FLAGS()"
	^self geosMessage: #[110 8 2 0 1]!

progressDialogSuspendCancel
	"@message ConnectProgressDialogFlags MSG_CONNECT_PROGRESS_DIALOG_SUSPEND_CANCEL()"
	^self geosMessage: #[110 9 2 0 1]!

progressDialogResumeCancel
	"@message void MSG_CONNECT_PROGRESS_DIALOG_RESUME_CANCEL()"
	^self geosMessage: #[110 10 2 0 0]!

!

